/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.ConfigChangeAdapter;
import ibm.nways.jdm.ConfigChangeEvent;
import ibm.nways.jdm.ConfigChangeListener;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.GraphicPanelProducer;
import ibm.nways.jdm.Icon;
import ibm.nways.jdm.IconArea;
import ibm.nways.jdm.JdmServer;
import ibm.nways.jdm.MessageDialog;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.RemoteStatusImpl;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.Naming;
import java.util.ResourceBundle;
import netscape.security.PrivilegeManager;

public abstract class JdmBrowser
extends BrowserApplet
implements GraphicPanelProducer,
ConfigChangeListener {
    private RemoteModel jdmModel;
    private JdmServer jdmServer;
    private GraphicPanel graphicPanel;
    private int serverPortNumber = -1;
    private Icon configChangedIcon;
    private boolean configChanged = false;
    private static ResourceBundle myResources = null;
    private static final String JdmServerPortKey = "jdmServerPort";
    private static final String InstrumentationContextKey = "instrumentationContext";
    private static final String ConfigChangedImageName = "/ibm/nways/jdm/configChanged.gif";

    public void init() {
        String string;
        if (this.isNetscape()) {
            PrivilegeManager.enablePrivilege("UniversalConnect");
        }
        if ((string = this.getParameter(JdmServerPortKey)) == null) {
            string = Integer.toString(2099);
        }
        this.serverPortNumber = Integer.parseInt(string);
        System.out.println("server port is:" + this.serverPortNumber);
        Image image = this.imageFrom(this, ConfigChangedImageName);
        if (image != null) {
            this.configChangedIcon = new Icon(image);
            this.configChangedIcon.setFlyOver(new GraphicFlyOver(JdmBrowser.getJdmBrowserResource("ConfigChanged")));
            MenuItem menuItem = new MenuItem(JdmBrowser.getJdmBrowserResource("RedrawConfig"));
            1 var4_4 = new 1();
            menuItem.addActionListener(var4_4);
            this.configChangedIcon.addPopupMenuItem(menuItem);
        }
        super.init();
    }

    public RemoteModel getModel() {
        return this.jdmModel;
    }

    public void setModel(RemoteModel remoteModel) {
        this.jdmModel = remoteModel;
        System.out.println("JdmBrowser Model is " + remoteModel.toString());
    }

    public void postBannerInit() {
        this.initJdmServer();
        this.checkLicense();
        this.initJdmModel();
        try {
            ConfigChangeAdapter configChangeAdapter = new ConfigChangeAdapter(this);
            this.jdmModel.addWatcher(configChangeAdapter);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void initJdmServer() {
        Object object;
        boolean bl = false;
        try {
            object = Integer.toString(this.serverPortNumber);
            this.jdmServer = (JdmServer)Naming.lookup("//" + this.getCodeBase().getHost() + ":" + (String)object + "/JdmServer");
            System.out.println("JdmServer version: " + this.jdmServer.getVersion());
            bl = !this.jdmServer.isReady();
        }
        catch (Exception exception) {
            bl = true;
            System.out.println("JdmBrowser exception:");
            exception.printStackTrace();
        }
        if (bl) {
            object = new MessageDialog(this.getFrame(), JdmBrowser.getJdmBrowserResource("BadServerMsg"), true);
            ((Dialog)object).setTitle(JdmBrowser.getJdmBrowserResource("BadServerTitle"));
            ((Dialog)object).show();
        }
    }

    private void initJdmModel() {
        try {
            RemoteStatusImpl remoteStatusImpl = new RemoteStatusImpl();
            this.setModel(this.jdmServer.getModelFor(this.getParameter(InstrumentationContextKey), this.getModelTypeName(), remoteStatusImpl));
            return;
        }
        catch (Exception exception) {
            System.out.println("initJdmModel exception:");
            exception.printStackTrace();
            return;
        }
    }

    public int getServerPortNumber() {
        return this.serverPortNumber;
    }

    public abstract String getModelTypeName();

    protected void resetGraphicPanel() {
        this.graphicPanel = null;
        super.resetGraphicPanel();
    }

    public GraphicPanel getGraphicFor(NavigationDestination navigationDestination, GraphicPanel graphicPanel, NavigationContext navigationContext) {
        if (this.graphicPanel == null) {
            this.graphicPanel = this.getDeviceGraphicPanel();
        }
        return this.graphicPanel;
    }

    protected final NavigationPoint createNavTreeRoot() {
        NavigationPoint navigationPoint = this.getNavTreeRoot();
        if (navigationPoint != null) {
            GraphicPanelProducer graphicPanelProducer;
            NavigationDestination navigationDestination = navigationPoint.getDestination();
            if (navigationDestination == null) {
                navigationDestination = new NavigationDestination(null);
            }
            if (navigationDestination.getModel() == null) {
                navigationDestination.setModel(this.getModel());
            }
            if ((graphicPanelProducer = navigationDestination.getGraphicPanelProducer()) == null) {
                navigationDestination.setGraphicPanelProducer(this);
            }
        }
        return navigationPoint;
    }

    protected abstract NavigationPoint getNavTreeRoot();

    protected void getRestOfNavTree() {
    }

    public abstract GraphicPanel getDeviceGraphicPanel();

    public void configChanged(ConfigChangeEvent configChangeEvent) {
        System.out.println("Config change event: " + configChangeEvent);
        if (!this.configChanged && this.configChangedIcon != null) {
            this.configChanged = true;
            this.addTrayIcon(this.configChangedIcon);
        }
    }

    public void refreshAll() {
        super.refreshAll();
        if (this.configChanged && this.configChangedIcon != null) {
            this.configChanged = false;
            this.removeTrayIcon(this.configChangedIcon);
        }
    }

    public void addTrayIcon(Icon icon) {
        icon.setSize(16, 16);
        IconArea iconArea = this.getFooter().getIconArea();
        iconArea.addIcon(icon);
        iconArea.doLayout();
        this.getFooter().doLayout();
        this.doLayout();
        this.getFooter().doLayout();
        iconArea.doLayout();
    }

    public void removeTrayIcon(Icon icon) {
        IconArea iconArea = this.getFooter().getIconArea();
        iconArea.removeIcon(icon);
        iconArea.doLayout();
        this.getFooter().doLayout();
        this.doLayout();
        this.getFooter().doLayout();
        iconArea.doLayout();
    }

    private void checkLicense() {
        Object object;
        boolean bl = false;
        String string = null;
        if (this.jdmServer != null) {
            try {
                if (!this.jdmServer.hasValidLicense()) {
                    bl = true;
                    object = this.jdmServer.getLicenseMsg();
                    if (object == null) {
                        object = JdmBrowser.getJdmBrowserResource("LicenseNoMsg");
                    }
                    string = String.valueOf(JdmBrowser.getJdmBrowserResource("LicenseMsgPrefix")) + (String)object;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = true;
                string = String.valueOf(JdmBrowser.getJdmBrowserResource("LicenseMsgPrefix")) + JdmBrowser.getJdmBrowserResource("LicenseSvrProb");
            }
        }
        if (bl) {
            object = new MessageDialog(this.getFrame(), string, true);
            ((Dialog)object).setTitle(JdmBrowser.getJdmBrowserResource("LicenseProbTitle"));
            ((Dialog)object).show();
            this.jdmServer = null;
        }
    }

    protected static String getJdmBrowserResource(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.JdmBrowserResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JdmBrowser.this.refreshAll();
        }

        /* synthetic */ 1() {
        }
    }
}

